from typing import List, Dict

class MeasurerMetaclass(type):
    @property
    def supported_measurements(self) -> List[str]:
        raise NotImplementedError('supported_measurements must be implemented')

class Measurer(metaclass=MeasurerMetaclass):
    def __init__(self, requested_measurements: List[str]):
        self.requested_measurements = requested_measurements

    def measure(self) -> Dict[str, float]:
        raise NotImplementedError('measure must be implemented')